/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : Unlimited Scan
/* - Contents: α׷ A/D CH0 CH1 ä Unlimited scan
/*     ̿Ͽ A/D convert ϰ   COMI_US_FileSaveFirst(...),
/*     COMI_US_FileSaveNext(...), COMI_US_FileSaveStop(...) Լ ̿
/*     Ͽ Ͽ ϴ Դϴ.
/*
/* - Remarks : 
/*     1.   COMI-SD101 带 ϴ  ۼǾϴ.
/*      ٸ 带 ϴ 쿡 COMI_LoadDevice(...)Լ 
/*     ù ° Ķ͸ ˸ ̽ ID ٲپ մϴ.   
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "Comidas.h"

#define DEV_ID	COMI_SD101
#define NUM_CH	2	/* Number of channels */
#define S_FREQ	1000	/* Scan freq. -> 1000 Hz */
#define MSB		10240	/* Max scans/buffer =>   scan  ũ⸦ ϴµ  */
						/* 1024  ϴ° .                           */

void main (void)
{
	HANDLE hDevice;
	int ch_list[2] = {0, 4};  /* Scan channel list : 0  4 ä */
	float progress;
	ULONG dwSavedScanCnt=0;

	/* Load DLL */
	if(!COMI_LoadDll()){
		printf("Comidas.dll load failure");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}
	/* Load Device */
	hDevice = COMI_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		printf("Can't load specified device!");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMI_UnloadDll();
		exit(0);
	}

	// Set A/D range //
	COMI_AD_SetRange(hDevice, 0, -10, 10);
	COMI_AD_SetRange(hDevice, 4, -10, 10);
	
	printf("A/D Scan Ϸ ƹŰ ʽÿ.\n");
	printf("ƹŰ ٽ  α׷ ˴ϴ.\n");
	_getch();
	
	/* start unlimited scan */
	long act_freq = COMI_US_Start (hDevice, NUM_CH, ch_list, S_FREQ, MSB, TRS_SINGLE);
	if(act_freq < 0){
		/* Error ó */
		printf("Error : Failed to start unlimited scan!");
		printf("%s", COMI_ErrorString (COMI_LastError()));
		COMI_UnloadDevice(hDevice);
		COMI_UnloadDll();
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}

	// Start file save //
	printf("A/D Scan data file save is started !\n");
	printf("Press any key to stop !\n");
	dwSavedScanCnt = 0;
	if(COMI_US_FileSaveFirst (hDevice, "c:\\ComiUscan.bin", TRUE)) 
	{
		while(!kbhit())
		{
			Sleep(100);
			dwSavedScanCnt += COMI_US_FileSaveNext(hDevice); // Continue file save
			printf("Total save scan count = %u\n", dwSavedScanCnt);
		}
	}
	COMI_US_FileSaveStop(hDevice); // Stop file save
	COMI_US_Stop (hDevice, TRUE); // Stop unlimited scan

	// Start binary file to text file conversion //
	COMI_US_FileConvert ("c:\\ComiUscan.bin", "c:\\ComiUscan.txt", 0);

	//  Scan Ͱ  Conversion ð  ɸǷ //
	// Conversion  üũϿ ڿ ش.           // 
	while((progress = COMI_US_CheckFileConvert()) < 100.f){
		printf("File conversion progress = %.1f %c\n", progress, '%');
	}

	COMI_UnloadDevice(hDevice);
	COMI_UnloadDll();
}
